
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class Competence : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Competence>
    {
        #region Static factory
        private static Competence _factory = null;

        public static Competence DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Competence();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_CompetenceView";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Abbreviation", "Abbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Weight", "Weight"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsActive", "IsActive"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ImageFileURL", "ImageFileURL"));   
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.Competence>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.Competence.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("IsActive", Gemini.Core.BL.DAL.SqlTypes.Bit));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_CompetenceView_RestoreBySearch";
            }
        }
        #endregion
    }
}
